package main

import (
	"bufio"
	"fmt"
	"net"
	"os"
)

// https://systembash.com/a-simple-go-tcp-server-and-tcp-client/
// firstly run server.go
// then run client.go (go run client.go)
// then type any message you want to send to server.

const (
	CONN_HOST = "localhost"
	CONN_PORT = "3333"
	CONN_TYPE = "tcp"
)

func main() {

	for {
        // TODO:
		// 1. connect to this socket
		conn, _ := net.Dial(CONN_TYPE, CONN_HOST+":"+CONN_PORT)
        // 2. create a request: e.g., read in input from stdin
		reader := bufio.NewReader(os.Stdin)
		fmt.Print("Text to send: ")
		text, _ := reader.ReadString('\n')
		// 3. send request to server by writing on the socket
		fmt.Print(text)
		fmt.Fprintf(conn, text+"\n")
		// 4. receive and print the response
		message, _ := bufio.NewReader(conn).ReadString('\n')
		fmt.Print("Message from server: " + message)
	}
}
