package main

import (
	"os"
	"log"
	"fmt"
	"time"
	"bufio"
	"net/rpc"
)

type Request struct {
	UserName string
}

// The struct that will hold the RPC call's response. This should live in a
// common file with client.go's definition, but we're trying to keep things
// simple
type ServerTimestamps struct {
	T2, T3 time.Time
}

// TODO
// GetServerTime implements Cristian's algorithm
// 1. Keep track of the appropriate timestamps from the local machine.
//    Remember to get T1 close to the beginning of the function!
// 2. Request T2 and T3 from the server via an RPC call
//    - serviceMethod: Listener.GetServerTimestamps
//    - args: Request
//    - reply: ServerTimestamps
// 3. Compute the server timestamp (watch out for duration vs. time)
func GetServerTime(request *Request, client *rpc.Client) time.Time {

}

// Run as follows:
// go run client.go [NetID] [IP] [PORT]
func main() {
  // Build request object
	request := new(Request)
	request.UserName = os.Args[1]

  // Create TCP connection
	client, err := rpc.Dial("tcp", os.Args[2] + ":" + os.Args[3])
	if err != nil {
		log.Fatal(err)
	}

  // Simple UI. Feel free to change.
	in := bufio.NewReader(os.Stdin)

	for {
		print("Press ENTER key to get time: ")
		_, _, err := in.ReadLine()
		if err != nil {
			log.Fatal(err)
		}

		reply := GetServerTime(request, client)

		fmt.Println(reply)
	}
}
