package main

import (
	"log"
	"net"
	"time"
	"net/rpc"
	"math/rand"
)

type Request struct {
	UserName string
}

type ServerTimestamps struct {
	T2, T3 time.Time
}

type Listener int

func (l *Listener) GetServerTimestamps(request Request, reply *ServerTimestamps) error {
	log.Printf("Received request from %s\n", request.UserName)
	result := new(ServerTimestamps)

	result.T2 = time.Now()

	r := rand.New(rand.NewSource(99))
	time.Sleep(time.Duration(r.Int() % 100) * time.Millisecond)

	result.T3 = time.Now()

	*reply = *result
	return nil
}

func main() {
	// Creating an address to listen on
	address, err := net.ResolveTCPAddr("tcp", "0.0.0.0:42586")
	if err != nil {
		log.Fatal(err)
	}

	// Creating a TCP server
	inbound, err := net.ListenTCP("tcp", address)
	if err != nil {
		log.Fatal(err)
	}

	// Create a new listener that will handle RPCs
	listener := new(Listener)

	// Register the listener and accept inbound RPCs
	rpc.Register(listener)
	rpc.Accept(inbound)
}
