package main

import (
	"fmt"
	"math/rand"
	"time"
)

type Result string

func fakeServe(kind, query string) Result {
	time.Sleep(time.Duration(rand.Intn(100)) * time.Millisecond)
	return Result(fmt.Sprintf("%s result for %q \n", kind, query))
}

func acquire(query string, server ...string) Result {
	c := make(chan Result)
	search := func(i int) { c <- fakeServe(server[i], query) }
	for i := range server {
		go search(i)
	}
	return <-c
}

func Youtube(query string) (results []Result) {
	c := make(chan Result)

	go func() { c <- acquire(query, "Video1", "Video2") }()
	go func() { c <- acquire(query, "Suggestion1", "Suggestion2") }()
	go func() { c <- acquire(query, "Ads1", "Ads2") }()

	timeout := time.After(80 * time.Millisecond)

	for i := 0; i < 3; i++ {
		select {
		case result := <-c:
			results = append(results, result)
		case <-timeout:
			fmt.Println("timeout")
			return
		}
	}
	return results
}

func main() {
	rand.Seed(time.Now().UnixNano())
	start := time.Now()
	result := Youtube("dancing")
	elapsed := time.Since(start)
	fmt.Println(result)
	fmt.Println(elapsed)
}
