package main

import (
	"fmt"
	"math/rand"
	"time"
)

func notify(service string) <-chan string { //reciever channel
	c := make(chan string)
	fmt.Println("In channel")
	go func() {
		for i := 0; ; i++ {
			c <- fmt.Sprintf("%s %d", service, i)
			time.Sleep(time.Duration(rand.Intn(1000)) * time.Millisecond)
		}
	}()
	return c
}

func main() {
	email := notify("email")
	chat := notify("chat")
	i := 0
	for i < 10 {
		select {
		case <-email:
			fmt.Printf("You've Got Mail\n")
			i++
		case <-chat:
			fmt.Printf("Someone is chatting you\n")
			i++
		default:
			fmt.Printf("Nothing new: You many chill\n")
			time.Sleep(500 * time.Millisecond)
		}
	}
	fmt.Println("I've seen enough notifications")

}
