//Based on: https://stackoverflow.com/questions/26135616/understand-the-code-go-concurrency-pattern-daisy-chain/26159823#26159823

package main

import (
	"fmt"
	"math/rand"
)

func f(left chan<- int, right <-chan int) {
	if rnd := rand.Intn(100); rnd != 0 {
		left <- <-right
	} else {
		left <- rand.Intn(10)

	}
}

func main() {
	const n = 100000

	// first we construct an array of n+1 channels each being a 'chan int'
	var channels [n + 1]chan int
	for i := range channels {
		channels[i] = make(chan int)
	}

	// now we wire n goroutines in a chain
	for i := 0; i < n; i++ {
		go f(channels[i], channels[i+1])
	}

	// insert a value into the right-hand end
	go func(c chan<- int) { c <- 1 }(channels[n])

	// pick up the value emerging from the left-hand end
	fmt.Println(<-channels[0])
}
