package main

import (
	"fmt"
	"math/rand"
	"time"
)

func notify(service string) <-chan string { //reciever channel
	c := make(chan string)
	go func() {
		for i := 0; ; i++ {
			c <- fmt.Sprintf("%s %d", service, i)
			time.Sleep(time.Duration(rand.Intn(1000)) * time.Millisecond)
		}
	}()
	return c
}

func main() {
	email := notify("email")
	chat := notify("chat")
	for i := 0; i < 5; i++ {
		fmt.Println(<-email)
		fmt.Println(<-chat)
	}
	fmt.Println("I've seen enough notifications")

}
