package main

import (
	"fmt"
	"math/rand"
	"time"
)

func notify(service string) <-chan string { //reciever channel
	c := make(chan string)
	go func() {
		for i := 0; ; i++ {
			c <- fmt.Sprintf("%s %d", service, i)
			time.Sleep(time.Duration(rand.Intn(1000)) * time.Millisecond)
		}
	}()
	return c
}

func fanInChannels(ch1, ch2 <-chan string) <-chan string {
	c := make(chan string)
	go func() {
		for {
			c <- <-ch1
		}
	}()
	go func() {
		for {
			c <- <-ch2
		}
	}()
	return c
}

func main() {
	rand.Seed(20)
	ch := fanInChannels(notify("email"), notify("chat"))
	for i := 0; i < 10; i++ {
		fmt.Println(<-ch)
	}
	fmt.Println("I've seen enough notifications")

}
