package main

import (
	"fmt"
	"math/rand"
	"time"
)

func notify(service string) chan string {
	c := make(chan string)
	go func() {
		for i := 0; ; i++ {
			c <- fmt.Sprintf("%s %d", service, i)
			time.Sleep(time.Duration(rand.Intn(100)) * time.Millisecond)
		}
	}()
	return c
}
func main() {
	email := notify("email")
	chat := notify("chat")

	for {
		select {
		case <-email:
			fmt.Println("Mail...")

		case <-chat:
			fmt.Println("Chat...")

		default:
			fmt.Println("...")
			time.Sleep(200 * time.Millisecond)
		}
	}

	fmt.Println("That's enough")
}
